<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] 	= 'home';
$route['404_override'] 			= '';
$route['translate_uri_dashes'] 	= FALSE;

/*** Frontend URLs ***/
$route['privacy-policy']        = 'home/privacyAndPolicies';
$route['terms-conditions']      = 'home/termsAndCondidtions';
$route['save-contact-us']       = 'home/save';
$route['add-to-cart']           = 'cart/add';
$route['review-cart']           = 'cart/view';
$route['remove-item/(:any)']    = 'cart/removeItem/$1';
$route['checkout']              = 'cart/checkOutPage';

/*** Admin URLs ***/
$route['adminex']                               = 'adminex/login/index';
$route['adminex/logout']                        = 'adminex/logout/index';
$route['adminex/dashboard']                     = 'adminex/dashboard/index';

$route['adminex/list-category']                 = 'adminex/category/index';
$route['adminex/save-category']                 = 'adminex/category/add';
$route['adminex/edit-category']                 = 'adminex/category/edit';
$route['adminex/delete-category/(:num)']        = 'adminex/category/delete/$1';

$route['adminex/list-product']                  = 'adminex/product/index';
$route['adminex/add-product']                   = 'adminex/product/add';
$route['adminex/edit-product/(:num)']           = 'adminex/product/edit/$1';
$route['adminex/delete-product/(:num)/(:any)']  = 'adminex/product/delete/$1/$2';

$route['adminex/list-coupons']                  = 'adminex/coupons/index';
$route['adminex/save-coupons']                  = 'adminex/coupons/add';
$route['adminex/edit-coupons']                  = 'adminex/coupons/edit';
$route['adminex/delete-coupons/(:num)']         = 'adminex/coupons/delete/$1';
