<?php defined('BASEPATH') or exit('No direct script access allowed');

class Cart extends CI_Controller
{
  function __construct()
  {
    parent::__construct();
    date_default_timezone_set("Asia/Kolkata");
  }

  public function add()
  {
    $data = array(
      'id'    => $this->input->post('id'),
      'name'  => $this->input->post('name'),
      'pic'   => $this->input->post('p_image'),
      'price' => $this->input->post('price'),
      'qty'   => $this->input->post('qty'),
      'wt'    => $this->input->post('weight')
    );

    $this->cart->insert($data);
    redirect(base_url('review-cart'));
    /* $this->session->set_flashdata('success', $this->input->post('name').' has been successfully added to your cart.');
    redirect(base_url('#product')); */
  }

  public function view()
  {
    $this->load->view('layouts/header');
    $this->load->view('cart/review_cart');
    $this->load->view('layouts/footer');
  }
  
  public function removeItem($rowid)
  {
    if (!empty($rowid)) {
      $this->cart->remove($rowid);
    }
    redirect('review-cart');
  }
  
  public function updateProductQty()
  {
    $rowid = $this->input->post('rowid');
    $qty   = $this->input->post('qty');

    $data = array(
      'rowid' => $rowid,
      'qty'   => $qty
    );

    $this->cart->update($data);
    echo 'success';
  }

  public function checkOutPage()
  {
    if ($this->cart->total_items() == 0) {
      $this->session->set_flashdata('error','Your cart is empty. Please add products first.');
      redirect('review-cart'); exit();
    } else {
      $this->load->view('layouts/header');
      $this->load->view('cart/check_out');
      $this->load->view('layouts/footer');
    }
  }

}
?>