<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

  function __construct() {
    parent::__construct();
    date_default_timezone_set("Asia/Kolkata");
  }

	public function index(){
    $data['products'] = $this->CommonModel->selectOrderByWhereRecord(array('id','product_name','product_img','product_price','sale_price','weight','weight_unit','quantity'),'id','ASC',TBL_PRODUCT_LIST,array('status' => 1));
    $this->load->view('layouts/header');
    $this->load->view('home/index',$data);
    $this->load->view('layouts/footer');
	}


  public function save()
  {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    $params = $this->input->post();
    $params = array_map('trim', $params);
    $params = $this->security->xss_clean($params);

    $this->form_validation->set_rules('full_name', 'Full Name', 'required|min_length[3]');
    $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'required|min_length[10]|max_length[12]');
    $this->form_validation->set_rules('address', 'Address', 'required');
    $this->form_validation->set_rules('message', 'Message', 'required|min_length[10]');

    if ($this->form_validation->run() == FALSE) {
      $data['status']   = 'error';
      $data['errors']   = $this->form_validation->error_array();
      $data['csrfHash'] = $this->security->get_csrf_hash();
    } else {
      $insertArray = [
        'full_name'  => $params['full_name'],
        'email'      => $params['email'],
        'phone'      => $params['phone'],
        'address'    => $params['address'],
        'message'    => $params['message'],
        'created_at' => date('Y-m-d H:i:s')
      ];

      $lastInsertId = $this->CommonModel->AddRecord($insertArray, TBL_CONTACT_US);

      if ($lastInsertId > 0) {
        $data['status']   = 'success';
        $data['message']  = 'The contact us form has been saved successfully.';
      } else {
        $data['status']   = 'error';
        $data['message']  = 'Something went wrong while submitting the contact us.';
      }
      $data['csrfHash'] = $this->security->get_csrf_hash();
      echo json_encode($data);
    }
  }

  public function privacyAndPolicies()
  {
    $this->load->view('layouts/header');
    $this->load->view('home/privacy_policy');
    $this->load->view('layouts/footer');
  }

  public function termsAndCondidtions()
  {
    $this->load->view('layouts/header');
    $this->load->view('home/terms_conditions');
    $this->load->view('layouts/footer');
  }

  public function cart()
  {
    $this->load->view('layouts/header');
    $this->load->view('home/cart');
    $this->load->view('layouts/footer');
  }

}
?>