<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Category extends CI_Controller {

	function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		if (!isLoggedIn()) {
			redirect(base_url('adminex'));
			exit();
		}
	}
	
	/**
	* Load Category List Page Method
	* 
	* @param1       
	* @return       view page
	* @access       public
	* @author       M.K.Sah
	* @copyright    N/A
	* @link         application/Category
	* @since        21th Jan 2026
	* @deprecated   N/A
	**/
	
	public function index(){
		
		$data = array();
		$where_clause = '';
		$where = '`status` = 1 AND ';
		$param  = $this->input->get();
		$param  = array_map('trim', $param);
		$param = $this->security->xss_clean($param);

		$orderbyfld = 'category_name';

		if (isset($param['category_id']) && $param['category_id'] != '') {
			$data['catID'] = $param['category_id'];
			$where .= "status = 1 AND id = '" . $param['category_id'] . "' AND ";
		}
		if ($where != '') {
			$where_clause = substr($where, 0, -4);
		}
		$this->load->library('pagination');
		$offset = trim($this->input->get('per_page'));
		$this->db->order_by($orderbyfld, 'ASC');
		$query = $this->CommonModel->RetriveRecordByWhere(TBL_CATEGORY, $where_clause);
		$config['base_url']        = base_url() . "adminex/category?" . http_build_query($data);
		$config['total_rows']      = $query->num_rows();
		$config['per_page']        = PAGINATION_LIMIT;
		$config['full_tag_open']   = '<div class="paging_simple_numbers"><nav><ul class="pagination pagination-sm m-0 float-right">';
		$config['full_tag_close']  = '</ul></nav></div>';
		$config['num_tag_open']    = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close']   = '</span></li>';
		$config['cur_tag_open']    = '<li class="page-item active"><span class="page-link">';
		$config['cur_tag_close']   = '<span class="sr-only">(current)</span></span></li>';
		$config['next_tag_open']   = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close']  = '</span></li>';
		$config['prev_tag_open']   = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close']  = '</span></li>';
		$config['first_tag_open']  = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['last_tag_open']   = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close']  = '</span></li>';
		$config['page_query_string'] = TRUE;
		$this->pagination->initialize($config);
		$data['links']      = $this->pagination->create_links();
		$data['TotalRec']   = $config['total_rows'];
		$data['page']       = !empty($offset) ? $offset : 0;
		
		$data['catFilters'] = $this->CommonModel->selectOrderByWhereRecord(array('id','category_name'),'category_name','ASC',TBL_CATEGORY,array('status'=>1));
		$data['categories'] = $this->CommonModel->selectOrderByWhereRecord(array('id','category_name'),'category_name','ASC',TBL_CATEGORY,$where_clause);
		
		$data['meta_title'] = 'Category List';
      	$data['meta_desc']  = 'Category List Description';
		$data['content'] 	= 'admin/category/index';
		$this->load->view('admin/layout_home', $data);
	}


	/**
	* Load Add Category Method
	* 
	* @param1       
	* @return       view page
	* @access       public
	* @author       M.K.Sah
	* @copyright    N/A
	* @link         application/Category
	* @since        21th Jan 2026
	* @deprecated   N/A
	**/
	
	public function add(){

		$params = $this->input->post();
		$params = array_map('trim', $params);
		$params = $this->security->xss_clean($params);

		$this->form_validation->set_rules('category_name', 'category name', 'trim|required|is_unique['.TBL_CATEGORY.'.category_name]',array('is_unique' => 'This %s already exists.' ));

		if ($this->form_validation->run() === FALSE) {
			$data['status']   = 'validation_error';
			$data['msg']      = validation_errors();
			$data['csrfHash'] = $this->security->get_csrf_hash();
		} else {
			$insertArray = array(
				'category_name' 	=> $params['category_name'],
				'status' 			=> 1,
				'created_on' 		=> date('Y-m-d H:i:s'),
				'updated_on' 		=> date('Y-m-d H:i:s')
			);
			$lastInsertId = $this->CommonModel->AddRecord($insertArray,TBL_CATEGORY);

			if ($lastInsertId > 0) {
				$data['status'] = 'success';
				$data['msg']    = 'The category has been saved successfully.';
			} else {
				$data['status'] = 'error';
				$data['msg']    = 'Something went wrong while adding the category.';
			}

			$data['csrfHash'] = $this->security->get_csrf_hash();
		}
		echo json_encode($data);
	}
	
	/**
	* Load Edit Product Method
	* 
	* @param1       
	* @return       view page
	* @access       public
	* @author       M.K.Sah
	* @copyright    N/A
	* @link         application/Product
	* @since        12th Jan 2026
	* @deprecated   N/A
	**/
	
	public function edit(){
		
		if($this->input->post('category_name') !=  $this->input->post('hdn_cat_name')){
			$this->form_validation->set_rules('category_name', 'category name', 'trim|required|is_unique['.TBL_CATEGORY.'.category_name]',array('is_unique' => 'This %s already exists.' ));
		}else{
			$this->form_validation->set_rules('category_name', 'category name', 'trim|required');
		}
		
		$params = $this->input->post();
		$params = array_map('trim', $params);
		$params = $this->security->xss_clean($params);

		if ($this->form_validation->run() === FALSE) {
			$data['status']   = 'validation_error';
			$data['msg']      = validation_errors();
			$data['csrfHash'] = $this->security->get_csrf_hash();
		}
		else {
			$setArray = array(
				'category_name' 	=> $params['category_name'],
				'status' 			=> 1,
				'updated_on' 		=> date('Y-m-d H:i:s')
			);
			
			$lastInsertId = $this->CommonModel->UpdateRecord($setArray,TBL_CATEGORY,'id',$params['category_id']);

			if ($lastInsertId > 0) {
				$data['status'] = 'success';
				$data['msg']    = 'The category has been updated successfully.';
			} else {
				$data['status'] = 'error';
				$data['msg']    = 'Something went wrong while updating the category.';
			}

			$data['csrfHash'] = $this->security->get_csrf_hash();
		}
		echo json_encode($data);
	}
	
	/**
	* Load Delete Product Method
	* 
	* @param1       
	* @return       view page
	* @access       public
	* @author       M.K.Sah
	* @copyright    N/A
	* @link         application/Product
	* @since        12th Jan 2026
	* @deprecated   N/A
	**/
	
	public function delete($id){

		if (!ctype_digit($id)) {
			show_error('Invalid request. Please try again.', 400);
			exit();
		}

		$prdID = (int) $id;
		$this->CommonModel->UpdateRecord(array('status'=> 0 ,'updated_on' => date('Y-m-d H:i:s')),TBL_CATEGORY,'id',$prdID);
		$this->session->set_flashdata('success', 'The category has been successfully deleted.');
		redirect(base_url('adminex/list-category'));
	}
	
	
}
?>