<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Description: Common class to reuse database query
* Requirements: PHP5 or above
* Auther: Manoj Kumar Sah
* 
* Class CommonModel
**/
	
class CommonModel extends CI_Model {

	public function __construct() {
		parent::__construct();
	}
	
	/**
	 * RetriveRecordByWhereRow
	 *
	 * Will return single row of provided table as array with provided where clause (optional) .
	 * 
	 * @param string $table
	 * @param array $where_clause
	 * @return array
	 */
	
	public function RetriveRecordByWhereRow($table,$where_clause) {
		$this->db->select('*');
		$this->db->from($table);
		if(!empty($where_clause))
		$this->db->where($where_clause);
		$query = $this->db->get();
		$row = $query->row();
		return $row;
	}
	
	/**
	* RetriveRecordByWhere
	*
	* Will return all row of provided table as array with provided where clause (optional).
	* 
	* @param string $table
	* @param array $where_clause
	* @return array
	*/
	
	public function RetriveRecordByWhere($table,$where_clause) {
		$this->db->select('*');
		$this->db->from($table);
		if(!empty($where_clause))
		$this->db->where($where_clause);
		$query = $this->db->get();
		return $query;
	}
	
	/**
	 * RetriveRecordByWhereOrderby
	 *
	 * Will return all row of provided table as array with provided where clause (optional) order by provided filed.
	 * 
	 * @param string $table
	 * @param array $where_clause
	 * @param string $orderbyfld
	 * @param string $orderby
	 * @return array
	 */
		
	public function RetriveRecordByWhereOrderby($table,$where_clause,$orderbyfld,$orderby) {
		$this->db->select('*');
		$this->db->from($table);
		if(!empty($where_clause))
		$this->db->where($where_clause);
		$this->db->order_by($orderbyfld, $orderby);
		$query = $this->db->get();
		
		return $query;
	}
	
	/**
	 * RetriveRecordByWhereOrderbyLimit
	 *
	 * Will return all row of provided table as array with provided where clause (optional) order by provided filed and limit.
	 * 
	 * @param string $table
	 * @param array $where_clause
	 * @param string $orderbyfld
	 * @param string $orderby
	 * @param string $limit
	 * @return array
	 */
	
	public function RetriveRecordByWhereOrderbyLimit($select_field,$table,$where_clause,$limit,$offset,$orderbyfld,$orderby){
		if(!empty($select_field)){
			$this->db->select($select_field);
		}else{
			$this->db->select('*');
		}
		$this->db->limit($limit,$offset);
		$this->db->from($table);
		if(!empty($where_clause))
		$this->db->where($where_clause);
		$this->db->order_by($orderbyfld, $orderby);
		$query = $this->db->get();
		return $query;
	}


	function selectOrderByWhereRecord($select_field,$order_by_filed,$order_by,$table,$where_clause) {
		$this->db->select($select_field);
		$this->db->order_by($order_by_filed,$order_by);
		$this->db->from($table);
		if(!empty($where_clause))
		$this->db->where($where_clause);
		return $this->db->get();
	}
	
	
	/**
	 * AddRecord
	 *
	 * Add provided records to provided table.
	 * 
	 * @param string $table
	 * @param array $row
	 * @return int
	 */
	
	function AddRecord($row,$table) {
		$this->db->insert($table, $row);           
		$insertid = $this->db->insert_id();
		return $insertid;
	}
	
	/**
	 * UpdateRecord
	 *
	 * Update provided records to provided table With provided condition.
	 * 
	 * @param string $table
	 * @param array $row
	 * @param string $idfld
	 * @param string $id
	 * @return int
	 */
	
	function UpdateRecord($row,$table,$idfld,$id)
	{
		$this->db->where($idfld, $id);
		$query = $this->db->update($table, $row);
		return $this->db->affected_rows();
	}
	
	/**
	* Count
	*
	* Count all records of provided table.
	* 
	* @param string $table_name
	* @return int
	*/
		
	public function Count($table_name) {
		$this->db->select('count(*) as count');
		$this->db->from($table_name);
		$query = $this->db->get()->row();  
		$tot_rec = $query->count;
		return $tot_rec;
	}
	
	/**
	* CountWhere
	*
	* Count records of provided table With provided condition.
	* 
	* @param string $table_name
	* @param array $where_clause
	* @return int
	*/
	
	public function CountWhere($table_name,$where_clause) {
		$this->db->select('count(*) as count');
		$this->db->where($where_clause);
		$this->db->from($table_name);
		$query = $this->db->get()->row();  
		$tot_rec = $query->count;
		return $tot_rec;
	}

	/**
	* Delete
	*
	* Delete single records of provided table With provided condition.
	* 
	* @param string $table_name
	* @param string $id
	* @param string $idfld
	* @return int
	*/

	public function Delete($table_name, $id, $idfld){
		$this->db->where($idfld, $id);
		$this->db->delete($table_name);
		return $this->db->affected_rows();
	}

	
	/**
	* GetRecordSql
	*
	* Will return all row of provided table using custom sql query.
	* 
	* @param string $sql
	* @return array
	*/
	
	public function GetRecordSql($sql)
	{	
		$query = $this->db->query($sql);
		return $query->result();	
	}


	public function RetriveSelectedRecordByWhereGroupBy($select,$table,$whereClause,$groupBy) {
		$this->db->select($select);
		$this->db->from($table);
		if(!empty($whereClause))
		$this->db->where($whereClause);
		$this->db->group_by($groupBy);
		$query = $this->db->get();
		return $query;
	}


	function getSelectedRecordByWhere($select_field,$table,$where_clause) {
		$this->db->select($select_field);
		$this->db->from($table);
		if(!empty($where_clause))
		$this->db->where($where_clause);
		return $this->db->get();
	}


	public function DeleteOnMultipleCondition($table_name, $whereCondition){
		$this->db->where($whereCondition);
		$this->db->delete($table_name);
		return $this->db->affected_rows();
	}


	public function UpdateRecordWithMultipleConditions($table,$setArray,$where_clause){
		if(!empty($where_clause))
		$this->db->where($where_clause);
		$this->db->update($table, $setArray);
		return $this->db->affected_rows();
	}

	public function set_cookies($user_id,$password){
		$expire = time()+60*60*24*7;
		setcookie("userEmail", $user_id , $expire);
	}
	
	public function delete_cookies(){
		setcookie("userEmail", "", time()-3600);
	}
	
	
	public function block_account($user_id){
		
		$login_flag = $this->db->where('email', $user_id)->get(TBL_USERS)->result();
		$login_count = $login_flag[0]->login_attempt + 1;
		
		if($login_count >= PWD_BLOCK_LIMIT){
			$this->db->set('status',0)->where('email', $user_id)->update(TBL_USERS);
		}
		
		$this->db->set('login_attempt',$login_count)->where('email', $user_id)->update(TBL_USERS);
		return $login_count;
	}
	
	public function unlock_account($user_id){
		$this->db->set('login_attempt',0)->where('email', $user_id)->update(TBL_USERS);
		$this->db->set('status',1)->where('email', $user_id)->update(TBL_USERS);
	}

}
//end of class
?>