<section class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-md-12">
				<div class="card card-success">
					<div class="card-body">
						<?php echo form_open('', array('method' => 'get')); ?>
							<div class="row">
								<div class="col-sm-4">
									<div class="form-group">
										<select name="category_id" class="form-control">
											<option value="">Select category</option>
											<?php foreach($catFilters->result() as $cat){ ?>
												<option value="<?php echo $cat->id; ?>" <?php if(isset($catID)&&$catID==$cat->id){ echo 'selected'; } ?>><?php echo $cat->category_name; ?></option>	
											<?php } ?>
										</select>
									</div>
								</div>
								<div class="col-sm-4">
									<div class="form-group">
										<button class="btn btn-info font-weight-bold mr-2"><i class='fas fa-search'></i> Search</button>
										<a href="<?php echo base_url('adminex/list-category');?>" class="btn btn-secondary font-weight-bold"><i class='fas fa-sync-alt'></i> Refresh</a>
									</div>
								</div>
							</div>
						<?php echo form_close(); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<!-- Main content -->
<section class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-md-12">
				<span id="displayMsg"></span>
				<?php
                if ($this->session->flashdata('error') != '') { ?>
                    <div class="alert alert-danger">
                        <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php } ?>
                <?php if ($this->session->flashdata('success') != '') { ?>
                    <div class="alert alert-primary">
                        <?php echo $this->session->flashdata('success'); ?>
                    </div>
                <?php } ?>
				<div class="card card-success">
					<div class="card-header">
						<h3 class="card-title"><?php echo isset($meta_title) ? $meta_title : ''; ?><span style="color: #070dff;"><?php if($TotalRec > 0){ echo ' [Total '.$TotalRec.' record(s) found]'; } ?></span></h3>

						<button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addCategoryModal" style="float: right;"><i class="fas fa-plus"></i> Add</button>
					</div>
					<div class="card-body table-responsive p-0">
						<table class="table table-bordered table-hover text-nowrap">
							<thead>
								<tr>
									<th style="width: 10px">SL</th>
									<th>Category Name</th>
									<th style="width: 10px">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
								if ($TotalRec > 0) {
									$i = 0;
									foreach ($categories->result() as $value)
									{ $i++;
										?>
										<tr>
											<td><?php echo $i + $page; ?></td>
											<td>
												<a href="javascript:void(0)" class="editCategoryBtn" data-id="<?php echo isset($value->id)?$value->id:'';?>" data-name="<?php echo isset($value->category_name)?$value->category_name:'';?>"><?php echo isset($value->category_name) ? $value->category_name : ''; ?></a>
											</td>
											<td>
												<a class="btn btn-block btn-danger" href="<?php echo base_url('adminex/delete-category/'.$value->id);?>" onclick="return confirm('Are you sure you want to delete this category?');"><i class="fas fa-trash"></i> Delete</a>
											</td>
										</tr>
										<?php
									}
								}
								else{
									echo '<tr><td colspan="8" style="text-align:center;"><strong>Oops!</strong> No Record Found</td></tr>';
								} ?>
							</tbody>
						</table>
					</div>
					<div class="card-footer clearfix">
						<?php echo $links; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- /.content -->

<div class="modal fade" id="addCategoryModal">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Add New Category</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<?php echo form_open('', ['method' => 'post','autocomplete' => 'off','id' => 'addCategoryFrm']); ?>
				<div class="modal-body">
					<div class="form-group">
						<label>Category Name <span class="text-danger">*</span></label>
						<input type="text" name="category_name" id="categoryNameID" class="form-control" placeholder="Enter category name">
						<span class="text-danger catErrr" style="font-size:14px;"></span>
					</div>
				</div>
				<div class="modal-footer justify-content-between">
					<!-- <button type="button" class="btn btn-default" data-dismiss="modal">Close</button> -->
					<button type="submit" class="btn btn-primary" id="addCategoryForm">Save Category</button>
				</div>
			<?php echo form_close(); ?>
		</div>
	</div>
</div>

<div class="modal fade" id="editCategory">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Add New Category</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<?php echo form_open('', ['method' => 'post','autocomplete' => 'off']); ?>
				<div class="modal-body">
					<div class="form-group">
						<label>Category Name <span class="text-danger">*</span></label>
						<input type="text" name="editCategoryName" id="editCatNameID" class="form-control editCategoryName" placeholder="Enter category name">
						<span id="editCatErrr" class="text-danger" style="font-size:14px;"></span>
					</div>
				</div>
				 <input type="hidden" name="category_id" id="editCategoryId">
				 <input type="hidden" name="hdn_cat_name" class="editCategoryName" value="">
				<div class="modal-footer justify-content-between">
					<button type="submit" class="btn btn-primary" id="updateCatBtn">Update Category</button>
				</div>
			<?php echo form_close(); ?>
		</div>
	</div>
</div>

