<section class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-md-12">
				<div class="card card-success">
					<div class="card-body">
						<?php echo form_open('', array('method' => 'get')); ?>
						<div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<select name="couponCode" class="form-control">
										<option value="">Select Coupon</option>
										<?php foreach ($couponFltr->result() as $cpn) { ?>
											<option value="<?php echo $cpn->id; ?>" <?php if (isset($catID) && $catID == $cpn->id) { echo 'selected'; } ?>><?php echo $cpn->coupon_code; ?></option>
										<?php } ?>
									</select>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<select name="statusID" class="form-control">
										<option value="">Select Status</option>
										<option value="1" <?php if (isset($statusD) && $statusD == '1') { echo 'selected'; } ?>>Active</option>
										<option value="0" <?php if (isset($statusD) && $statusD == '0') { echo 'selected'; } ?>>Inactive</option>
									</select>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<button class="btn btn-info font-weight-bold mr-2"><i class='fas fa-search'></i> Search</button>
									<a href="<?php echo base_url('adminex/list-coupons'); ?>" class="btn btn-secondary font-weight-bold"><i class='fas fa-sync-alt'></i> Refresh</a>
								</div>
							</div>
						</div>
						<?php echo form_close(); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<!-- Main content -->
<section class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-md-12">
				<span id="displayMsg"></span>
				<?php
				if ($this->session->flashdata('error') != '') { ?>
					<div class="alert alert-danger">
						<?php echo $this->session->flashdata('error'); ?>
					</div>
				<?php } ?>
				<?php if ($this->session->flashdata('success') != '') { ?>
					<div class="alert alert-primary">
						<?php echo $this->session->flashdata('success'); ?>
					</div>
				<?php } ?>
				<div class="card card-success">
					<div class="card-header">
						<h3 class="card-title"><?php echo isset($meta_title) ? $meta_title : ''; ?><span style="color: #070dff;"><?php if ($TotalRec > 0) {	echo ' [Total ' . $TotalRec . ' record(s) found]';} ?></span></h3>
						<button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addCouponsModal" style="float: right;"><i class="fas fa-plus"></i> Add</button>
					</div>
					<div class="card-body table-responsive p-0">
						<table class="table table-bordered table-hover text-nowrap">
							<thead>
								<tr>
									<th style="width: 10px">SL</th>
									<th>Coupon Code</th>
									<th>Coupon Type</th>
									<th>Discount Value</th>
									<th>Min Order Amount</th>
									<th>Expiry Date</th>
									<th>Status</th>
									<th style="width: 10px">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
								if ($TotalRec > 0) {
									$i = 0;
									foreach ($couponList->result() as $value)
									{ $i++;
										if(isset($value->discount_type) && $value->discount_type == 'PERCENT'){
											$disCountVal = number_format($value->discount_value, 0).'%';
										}else{
											$disCountVal = number_format($value->discount_value, 2);
										}
									?>
									<tr>
										<td><?php echo $i + $page; ?></td>
										<td><?php echo isset($value->coupon_code) ? $value->coupon_code : ''; ?></td>
										<td><?php echo isset($value->discount_type) ? $value->discount_type : ''; ?></td>
										<td><?php echo $disCountVal; ?></td>
										<td><?php echo isset($value->min_order_amount) ? $value->min_order_amount : ''; ?></td>
										<td><?php echo date('d-m-Y', strtotime($value->expiry_date)); ?></td>
										<td><?php echo isset($value->status)&&$value->status==1?'<span class="badge badge-success">Active</span>':'<span class="badge badge-danger">Inactive</span>'; ?></td>
										<td><?php if(isset($value->status) && $value->status == 1 ){ ?>
											<a class="btn btn-block btn-danger" href="<?php echo base_url('adminex/delete-coupons/' . $value->id); ?>" onclick="return confirm('Are you sure you want to deactivate this coupon?');"><i class="fas fa-trash"></i>Delete</a>
											<?php } ?>
										</td>
									</tr>
									<?php
									}
								} else {
									echo '<tr><td colspan="8" style="text-align:center;"><strong>Oops!</strong> No Record Found</td></tr>';
								} ?>
							</tbody>
						</table>
					</div>
					<div class="card-footer clearfix">
						<?php echo $links; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- /.content -->

<div class="modal fade" id="addCouponsModal">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Add New Coupons</h4>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			</div>
			<?php echo form_open('', ['method' => 'post', 'autocomplete' => 'off', 'id' => 'addCouponFrmID']); ?>
			<div class="modal-body">
				<div class="row">
					<div class="col-sm-4">
						<div class="form-group">
							<label>Coupon Code <span class="text-danger">*</span></label>
							<input type="text" name="coupon_code" id="couponCodeID" class="form-control" placeholder="Enter coupon code">
							<span class="text-danger cpnErrr" style="font-size:14px;"></span>
						</div>
					</div>

					<div class="col-sm-8">
						<div class="form-group">
							<label>Coupon Expiry Date <span class="text-danger">*</span></label>
							<input type="text" name="expiry_date" id="expiryDateID" class="form-control getDatePicker" readonly>
							<span class="text-danger cpnExpErrr" style="font-size:14px;"></span>
						</div>
					</div>
				</div>

				<div class="row">
					<div class="col-sm-4">
						<div class="form-group" >
							<label>Discount Type</label>
							<select class="form-control" name="discount_type" id="discountTypeID">
								<option value="">Select Type</option>
								<option value="PERCENT">PERCENT</option>
								<option value="FLAT">FLAT</option>
							</select>
						</div>
					</div>
					<div class="col-sm-4">
						<div class="form-group">
							<label>Discount Value</label>
							<input type="text" name="discount_value" id="discountValueID" class="form-control" placeholder="Enter discount value">
						</div>
					</div>
					<div class="col-sm-4">
						<div class="form-group">
							<label>Min Order Amt</label>
							<input type="text" name="min_order_amount" id="minOrderAmountID" class="form-control" placeholder="Enter min order amount">
						</div>
					</div>
				</div>

			</div>
			<div class="modal-footer justify-content-between">
				<button type="submit" class="btn btn-primary" id="saveCouponBtnID">Save Coupons</button>
			</div>
			<?php echo form_close(); ?>
		</div>
	</div>
</div>
