<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <META name="robots" content="index,follow">
  <META name="author" content="<?php echo AUTHOR; ?>">
  <META name="copyright" content="<?php echo COPYRIGHT_COMPANY . ' ' . date('Y'); ?>">
  <META name="description" content="<?php echo $meta_desc; ?>">
  <META name="keywords" content="">
  <meta name="revisit-after" content="7 days" />
  <title><?php echo $meta_title; ?></title>
  <!-- Mobile Meta -->
  <meta name="viewport" content="width=device-width, initial-scale=1" user-scalable="no">

  <link rel="shortcut icon" href="<?php echo base_url() . FAV_ICON ?>">

  <!--[if lt IE 9]>
  <script src="js/respond.min.js"></script>
  <![endif]-->

  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <link rel="stylesheet" href="<?php echo base_url(); ?>plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="<?php echo base_url(); ?>plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <link rel="stylesheet" href="<?php echo base_url(); ?>dist/css/adminlte.min.css">
</head>

<body class="hold-transition login-page">

  <div class="login-box">
    <div class="login-logo">
      <a href="javascript:void(0)"><?php echo COMPANY_NAME; ?></a>
    </div>
    <div class="card">
      <div class="card-body login-card-body">
        <p class="login-box-msg">Administrator Login</p>

        <?php echo form_open(); ?>
        <?php if ($this->session->flashdata('error') != '') { ?>
          <div class="alert alert-danger"> <?php echo $this->session->flashdata('error'); ?> </div>
        <?php } ?>
        <?php if ($this->session->flashdata('success') != '') { ?>
          <div class="alert alert-primary"> <?php echo $this->session->flashdata('success'); ?> </div>
        <?php } ?>

        <div class="input-group mb-3">
          <input type="text" name="username" class="form-control" placeholder="Email" autocomplete="off" value="<?php echo isset($_COOKIE['userEmail']) ? $_COOKIE['userEmail'] : ''; ?>">  
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <?php echo form_error('username', '<div class="text-danger">', '</div>'); ?>
        
        <div class="input-group mb-3">
          <input type="Password" name="password" class="form-control" placeholder="Password" autocomplete="off" value="">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <?php echo form_error('password', '<div class="text-danger">', '</div>'); ?>

        <div class="row">
          <div class="col-8">
            <div class="icheck-primary">
              <input type="checkbox" id="remember">
              <label for="remember">Remember Me</label>
            </div>
          </div>
          <div class="col-4">
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
          </div>
        </div>
        <?php echo form_close(); ?>

        <!-- <p class="mb-1">
        <a href="forgot-password.html">I forgot my password</a>
        </p>
        <p class="mb-0">
          <a href="register.html" class="text-center">Register a new membership</a>
        </p> -->

      </div>
    </div>
  </div>

  <script src="<?php echo base_url(); ?>plugins/jquery/jquery.min.js"></script>
  <script src="<?php echo base_url(); ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="<?php echo base_url(); ?>dist/js/adminlte.min.js"></script>

  <footer>
    <?php echo '<br>' . COMPANY_NAME . ' &copy; ' . date("Y") . ' ' . COPYRIGHT_COMPANY; ?>
  </footer>
</body>

</html>