<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <?php
                if ($this->session->flashdata('error') != '') { ?>
                    <div class="alert alert-danger">
                        <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php } ?>
                <?php if ($this->session->flashdata('success') != '') { ?>
                    <div class="alert alert-primary">
                        <?php echo $this->session->flashdata('success'); ?>
                    </div>
                <?php } ?>
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo isset($meta_title) ? $meta_title : ''; ?></h3>
                    </div>
                    <div class="card-body">
                        <?php echo form_open_multipart('', array('method' => 'post', 'autocomplete' => 'off')); ?>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Product Name<span class="text-danger">*</span></label>
                                    <input type="text" name="product_name" value="<?php echo set_value('product_name'); ?>" class="form-control" placeholder="Enter product name">
                                    <?php echo form_error('product_name', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Price<span class="text-danger">*</span></label>
                                    <input type="text" name="product_price" value="<?php echo set_value('product_price'); ?>" class="form-control" placeholder="Enter product price">
                                    <?php echo form_error('product_price', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Sale Price<span class="text-danger">*</span></label>
                                    <input type="text" name="sale_price" value="<?php echo set_value('sale_price'); ?>" class="form-control" placeholder="Enter product sale price">
                                    <?php echo form_error('sale_price', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Quantity<span class="text-danger">*</span></label>
                                    <input type="text" name="quantity" value="<?php echo set_value('quantity'); ?>" class="form-control" placeholder="Enter product sale price">
                                    <?php echo form_error('quantity', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Product Description</label>
                                    <textarea name="product_desc" class="form-control" rows="8"></textarea>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Select Category<span class="text-danger">*</span></label>
                                    <select name="category_id" class="form-control">
                                        <option value="">Select category</option>
                                        <?php foreach ($categories->result() as $cat) { ?>
                                            <option value="<?php echo $cat->id; ?>" <?php if (isset($catID) && $catID == $cat->id) { echo 'selected'; } ?>><?php echo $cat->category_name; ?></option>
                                        <?php } ?>
                                    </select>
                                    <?php echo form_error('category_id', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Weight<span class="text-danger">*</span></label>
                                    <input type="text" name="weight" value="<?php echo set_value('weight'); ?>" class="form-control" placeholder="Enter product weight">
                                    <?php echo form_error('weight', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Weight Unit<span class="text-danger">*</span></label>
                                    <select name="weight_unit" class="form-control">
                                        <option value="">Select weight unit</option>
                                        <option value="0">Gram</option>
                                        <option value="1">Kg</option>
                                    </select>
                                    <?php echo form_error('weight_unit', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Product Image<span class="text-danger">*</span> <small class="text-danger">(<?php echo ALLOWED_FILE_TYPE . ' type only.'; ?>)</small></label>
                                    <input type="file" name="product_image" class="form-control" accept="<?php echo ALLOWED_FILE_TYPE; ?>" onchange="readURL(this);" />
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <div class="image_preview_wrapper">
                                        <img id="preViewId" src="" style="display:none" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="text-center">
                                    <input type="submit" value="Save Product" class="btn btn-success">
                                    <a href="<?php echo base_url('adminex/add-product'); ?>" class="btn btn-secondary">Refresh</a>
                                </div>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->