<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <?php
                if ($this->session->flashdata('error') != '') { ?>
                    <div class="alert alert-danger">
                        <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php } ?>
                <?php if ($this->session->flashdata('success') != '') { ?>
                    <div class="alert alert-primary">
                        <?php echo $this->session->flashdata('success'); ?>
                    </div>
                <?php } ?>
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo isset($meta_title) ? $meta_title : ''; ?></h3>
                    </div>
                    <div class="card-body">
                        <?php echo form_open_multipart('', array('method' => 'post', 'autocomplete' => 'off')); ?>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Product Name<span class="text-danger">*</span></label>
                                    <input type="text" name="product_name" value="<?php echo isset($EditData->product_name) ? $EditData->product_name:'';?>" class="form-control" placeholder="Enter product name">
                                    <?php echo form_error('product_name', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Price<span class="text-danger">*</span></label>
                                    <input type="text" name="product_price" value="<?php echo isset($EditData->product_price) ? $EditData->product_price:'';?>" class="form-control" placeholder="Enter product price">
                                    <?php echo form_error('product_price', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Sale Price<span class="text-danger">*</span></label>
                                    <input type="text" name="sale_price" value="<?php echo isset($EditData->sale_price) ? $EditData->sale_price:'';?>" class="form-control" placeholder="Enter product sale price">
                                    <?php echo form_error('sale_price', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Quantity<span class="text-danger">*</span></label>
                                    <input type="text" name="quantity" value="<?php echo isset($EditData->quantity) ? $EditData->quantity:'';?>" class="form-control" placeholder="Enter product sale price">
                                    <?php echo form_error('quantity', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" name="product_hdn" value="<?php echo isset($EditData->product_name) ? $EditData->product_name:'';?>"/>
                        <input type="hidden" name="image_hdn" value="<?php echo isset($EditData->product_img) ? $EditData->product_img:'';?>"/>

                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Product Description<span class="text-danger">*</span></label>
                                    <textarea name="product_desc" class="form-control" rows="8"><?php echo isset($EditData->product_short_desc) ? $EditData->product_short_desc:'';?></textarea>
                                    <?php echo form_error('product_desc', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Select Category<span class="text-danger">*</span></label>
                                    <select name="category_id" class="form-control">
                                        <option value="">Select category</option>
                                        <?php foreach ($categories->result() as $cat) { ?>
                                            <option value="<?php echo $cat->id; ?>" <?php if (isset($EditData->cat_id) && $EditData->cat_id == $cat->id) { echo 'selected'; } ?>><?php echo $cat->category_name; ?></option>
                                        <?php } ?>
                                    </select>
                                    <?php echo form_error('category_id', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Product Weight<span class="text-danger">*</span></label>
                                    <input type="text" name="weight" value="<?php echo isset($EditData->weight) ? $EditData->weight:'';?>" class="form-control" placeholder="Enter product weight">
                                    <?php echo form_error('weight', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Weight Unit<span class="text-danger">*</span></label>
                                    <select name="weight_unit" class="form-control">
                                        <option value="">Select weight unit</option>
                                        <option value="0" <?php if (isset($EditData->weight_unit) && $EditData->weight_unit == 0) { echo 'selected'; } ?> >Gram</option>
                                        <option value="1" <?php if (isset($EditData->weight_unit) && $EditData->weight_unit == 1) { echo 'selected'; } ?> >Kg</option>
                                    </select>
                                    <?php echo form_error('weight_unit', '<div class="text-danger">', '</div>'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Product Image<span class="text-danger">*</span> <small class="text-danger">(<?php echo ALLOWED_FILE_TYPE . ' type only.'; ?>)</small></label>
                                    <input type="file" name="product_image" class="form-control" accept="<?php echo ALLOWED_FILE_TYPE; ?>" onchange="readURL(this);" />
                                </div>
                            </div>
                            <?php if(isset($EditData->product_img) && $EditData->product_img!=''){  ?>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <div class="image_preview_wrapper">
                                        <img src="<?php echo base_url();?>uploads/product/<?php echo isset($EditData->product_img)?$EditData->product_img:'';?>" alt="product image" width="100" height="100">
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <div class="image_preview_wrapper">
                                        <img id="preViewId" src="" style="display:none" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="text-center">
                                    <input type="submit" value="Update Product" class="btn btn-success">
                                    <a href="<?php echo base_url('adminex/edit-product/'.$EditData->id); ?>" class="btn btn-secondary">Refresh</a>
                                </div>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->