<section class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-md-12">
				<div class="card card-success">
					<div class="card-body">
						<?php echo form_open('', array('method' => 'get')); ?>
							<div class="row">
								<div class="col-4">
									<div class="form-group">
										<select name="category_id" class="form-control">
											<option value="">Select category</option>
											<?php foreach($categories->result() as $cat){ ?>
												<option value="<?php echo $cat->id; ?>" <?php if(isset($catID)&&$catID==$cat->id){ echo 'selected'; } ?>><?php echo $cat->category_name; ?></option>	
											<?php } ?>
										</select>
									</div>
								</div>
								<div class="col-4">
									<div class="form-group">
										<select name="product_id" class="form-control">
											<option value="">Select product</option>
											<?php foreach($products->result() as $prod){ ?>
												<option value="<?php echo $prod->id; ?>" <?php if(isset($prodID)&&$prodID==$prod->id){ echo 'selected'; } ?>><?php echo $prod->product_name; ?></option>
											<?php } ?>
										</select>
									</div>
								</div>
								<div class="col-sm-4">
									<div class="form-group">
										<button class="btn btn-info font-weight-bold mr-2"><i class='fas fa-search'></i> Search</button>
										<a href="<?php echo base_url('adminex/list-product');?>" class="btn btn-secondary font-weight-bold"><i class='fas fa-sync-alt'></i> Refresh</a>
									</div>
								</div>
							</div>
						<?php echo form_close(); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<!-- Main content -->
<section class="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-md-12">
				<?php
				if ($this->session->flashdata('error') != '') { ?>
					<div class="alert alert-danger">
						<?php echo $this->session->flashdata('error'); ?>
					</div>
				<?php } ?>
				<?php if ($this->session->flashdata('success') != '') { ?>
					<div class="alert alert-primary">
						<?php echo $this->session->flashdata('success'); ?>
					</div>
				<?php } ?>
				<div class="card card-success">
					<div class="card-header">
						<h3 class="card-title"><?php echo isset($meta_title) ? $meta_title : ''; ?>
						<span style="color: #070dff;"><?php if($TotalRec > 0){ echo ' [Total '.$TotalRec.' record(s) found]'; } ?></span>
					</h3>
					</div>
					<div class="card-body table-responsive p-0">
						<table class="table table-bordered table-hover text-nowrap">
							<thead>
								<tr>
									<th style="width: 10px">SL</th>
									<th>Image</th>
									<th>Product Name</th>
									<th style="width: 10px">Price</th>
									<th style="width: 10px">Sale Price</th>
									<th style="width: 10px">Weight</th>
									<th style="width: 10px">Quantity</th>
									<th>Category</th>
									<th style="width: 10px">Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
								if ($TotalRec > 0) {
									$i = 0;
									foreach ($productList->result() as $value)
									{ $i++;
										$deleteImage = isset($value->product_img)&&!empty($value->product_img)?$value->product_img:'';
										?>
										<tr>
											<td scope="row"><?php echo $i + $page; ?></td>
											<td>
												<img src="<?php echo base_url('uploads/product/'.$deleteImage);?>" alt="<?php echo isset($value->product_name) ? $value->product_name : ''; ?>" width="50" height="60">
											</td>
											<td><?php echo isset($value->product_name) ? $value->product_name : ''; ?></td>
											<td><?php echo isset($value->product_price) ? $value->product_price : ''; ?></td>
											<td><?php echo isset($value->sale_price) ? $value->sale_price : ''; ?></td>
											<td><?php echo isset($value->weight) ? $value->weight.' '.getWeightUnit($value->weight_unit): ''; ?></td>
											<td><?php echo isset($value->quantity) ? $value->quantity : ''; ?></td>
											<td><?php echo isset($value->category_name) ? $value->category_name : ''; ?></td>
											<td>
												<div class="btn-group">
													<button type="button" class="btn btn-success">Action</button>
													<button type="button" class="btn btn-success dropdown-toggle dropdown-hover dropdown-icon" data-toggle="dropdown"><span class="sr-only">Toggle Dropdown</span></button>
													<div class="dropdown-menu" role="menu"> <!-- <i class="fas fa-eye"></i> -->
														<a class="dropdown-item btn-outline-warning text-primary" href="<?php echo base_url('adminex/edit-product/'.$value->id);?>"><i class='fas fa-edit'></i> Edit Product</a>
														<div class="dropdown-divider"></div>
														<a class="dropdown-item btn-outline-danger text-danger" href="<?php echo base_url('adminex/delete-product/'.$value->id.'/'.$deleteImage);?>" onclick="return confirm('Are you sure you want to delete this record?');"><i class="fas fa-trash"></i> Delete Item</a>
													</div>
												</div>
											</td>
										</tr>
										<?php
									}
								}
								else{
									echo '<tr><td colspan="9" style="text-align:center;"><strong>Oops!</strong> No Record Found</td></tr>';
								} ?>
							</tbody>
						</table>
					</div>
					<div class="card-footer clearfix">
						<?php echo $links; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- /.content -->