<?php if (count($this->cart->contents()) > 0) { ?>
  <section class="progress_bar_new_section_two cart_page_top_heading_section">
    <div class="container">
      <div class="row">
        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12 order-2 order-lg-1">
          <div class="cart_page_top_heading_section_right cart_page_top_heading_section_right190357">
            <div class="cart-wrapper">
              <div class="cart-title_new_section_block456">Review Your Cart</div>
              <!-- CART ITEM -->
              <?php
              echo form_open('', array('method' => 'post'));
              $i = 1;
              foreach ($this->cart->contents() as $item): //echo "<pre>";print_r($item); 
              ?>
                <div class="cart-item">
                  <a href="<?php echo base_url('remove-item/' . $item['rowid']); ?>"><i class="fa-solid fa-trash-arrow-up delete-icon remove-item" data-rowid="<?php echo $item['rowid']; ?>"></i></a>

                  <?php echo form_hidden('rowid', $item['rowid']); ?>

                  <div class="d-flex gap-4 cart_item_flex_direction">
                    <div class="cart-img">
                      <img src="<?php echo base_url('uploads/product/' . $item['pic']); ?>" class="img-fluid">
                    </div>

                    <div class="flex-grow-1">
                      <div class="item-title"><?php echo $item['name']; ?></div>

                      <div class="d-flex align-items-center gap-3">
                        <div class="item-size"><?php echo $item['wt']; ?></div>

                        <div class="qty-box">
                          <button class="qty-btn minus" data-rowid="<?= $item['rowid']; ?>">−</button>
                          <span class="qty-value"><?php echo $item['qty']; ?></span>
                          <button class="qty-btn plus" data-rowid="<?= $item['rowid']; ?>">+</button>
                        </div>
                      </div>

                      <div class="price">₹<?php echo $item['price']; ?></div>
                    </div>
                  </div>
                </div>
              <?php $i++;
              endforeach;
              echo form_close(); ?>
            </div>
          </div>
        </div>
        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12 order-1 order-lg-2">
          <div class="progress_bar_new_section_two_right progress_bar_new_section_two_right4569">
            <div class="cart-box">
              <div class="cart-title cart-title9087">Total Price</div>
              <?php
              $delivery = 100;
              $subtotal = $this->cart->total();
              $netTotal = $subtotal + $delivery;
              ?>
              <!-- Summary -->
              <div class="summary-row">
                <span class="summary_row_one">Subtotal</span>
                <span class="summary_row_two">₹<?php echo $subtotal; ?></span>
              </div>
              <div class="summary-row">
                <span class="summary_row_one">Delivery</span>
                <span class="summary_row_two">₹<?php echo $delivery; ?></span>
              </div>
              <div class="summary-row summary-total">
                <span class="summary_total_one">Total</span>
                <span class="summary_total_two">₹<?php echo $netTotal; ?></span>
              </div>

              <div class="coupon-box coupon_box_cart_section">
                <a href="<?= base_url('checkout') ?>" class="pay-btn">Proceed to Checkout</a>
                <div class="footer-text"> Safe & Secure Payments • 100% Authentic Products </div>
              </div>

            </div>
          </div>
        </div>
      </div>
  </section>
<?php } else { ?>
  <?php if ($this->session->flashdata('error')) : ?>
    <div class="alert alert-warning">
      <?= $this->session->flashdata('error'); ?>
    </div>
  <?php endif; ?>

  <!-- echo '<div class="alert alert-danger">No items in your cart. Please visit the <a href="' . base_url('#product') . '">homepage</a> to add some items to your cart.</div>'; -->


  <section class="error_section error_class">
    <div class="container error_container error_class">
      <div class="row justify-content-center error_class">
        <div class="col-12 error_class">

          <h1 class="error_title error_class">Your Cart is Empty</h1>

          <div class="error_icon_wrap error_class">
            <img src=" <?php echo base_url('assets/images/cart-empty-image.webp'); ?> " alt="cart-empty" class="error_icon error_class">
          </div>

          <p class="error_text error_class">
            Looks like you haven’t added any products to your cart yet. Browse our premium range and add your favorites to get started.
          </p>

          <!-- Button -->
          <div class="error_btn_wrap error_class">
            <a href="<?php echo base_url('#product');?>" class="error_btn error_class">Go to Home</a>
          </div>

        </div>
      </div>
    </div>
  </section>

<?php } ?>