<section class="banner">
  <div class="container">
    <div class="banner_inner text-center">
      <h1><span><img src="assets/images/hero-heading-left-design.webp" class="img-fluid h1_span_one"> All Seasons Makhana <img src="assets/images/hero-heading-right-design.webp" class="img-fluid h1_span_two"></span>ELEGANCE IN EVERY BITE</h1>
      <p>Premium Makhana Products for a Healthier You — <span class="banner_p_span_one">Natural</span>, <span class="banner_p_span_two">Nutritious</span>, <span class="banner_p_span_three">Delicious</span>.</p>
    </div>
  </div>
</section>

<section class="always_fresh common_padding">
  <div class="container">
    <div class="row">

      <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12">
        <div class="always_fresh_left">
          <h2><img src="assets/images/secont-section-title-icon.webp" class="img-fluid"><span>ALWAYS FRESH</span></h2>
          <h3>Premium Quality Makhana</h3>
          <p>Carefully sourced and naturally processed, our Makhana delivers unmatched crunch and purity. Perfect for snacking, fasting, or daily healthy eating.</p>
          <div class="always_fresh_left_img">
            <img src="assets/images/second-section-always-fresh-image.webp" class="img-fluid">
          </div>
        </div>
      </div>

      <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-12 col-sm-12 col-12">
        <div class="always_fresh_right_inner">
          <div class="always_fresh_right">
            <img src="assets/images/second-section-nutrition-image.webp" class="img-fluid">
          </div>
          <div class="always_fresh_right_text">
            <h2><img src="assets/images/secont-section-title-icon.webp" class="img-fluid"><span>NUTRITION FIRST</span></h2>
            <h3>Rich in Protein & Antioxidants</h3>
            <p>Our Makhana is a natural source of plant protein and essential minerals that support heart health, digestion, and immunity.</p>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>

<section class="premium_makhana" id="product">
  <div class="container">
    <div class="premium_makhana_inner text-center">
      <h2>Our Premium Makhana Range</h2>
      <h3>Makhana — Pure, Delicious & Nutritious</h3>
      <p>A perfect blend of crunch and purity. Ideal for snacking, fasting, gifting, or daily nutrition.</p>
    </div>
    <div class="row">
    <?php foreach ($products->result() as $product) { //echo "<pre>";print_r($product->id); ?>      
      <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6 col-6">
        <div class="premium_makhana_block">
          <div class="premium_makhana_block_img text-center">
            <img src="<?php echo base_url('uploads/product/'.$product->product_img);?>" class="img-fluid">
          </div>
          <div class="premium_makhana_block_text d-flex justify-content-between">
            <div class="premium_makhana_block_text_left d-flex align-items-center">
              <h5><?php echo isset($product->sale_price)?'₹ '.(int)$product->sale_price:'';?></h5>
              <h6><?php echo isset($product->product_price)?'₹ '.(int)$product->product_price:'';?></h6>
            </div>
            <div class="premium_makhana_block_text_right">
              <p><?php echo isset($product->weight) ? (int)$product->weight.''.getWeightUnit($product->weight_unit): ''; ?></p>
            </div>
          </div>
          <div class="premium_makhana_block_button">
            
          <?php echo form_open('add-to-cart', ['method' => 'post']); ?>
            <input type="hidden" name="id" value="<?php echo $product->id;?>">
            <input type="hidden" name="name" value="<?php echo $product->product_name; ?>">
            <input type="hidden" name="p_image" value="<?php echo $product->product_img; ?>">
            <input type="hidden" name="price" value="<?php echo $product->sale_price; ?>">
            <input type="hidden" name="qty" value="<?php echo $product->quantity; ?>">
            <input type="hidden" name="weight" value="<?php echo isset($product->weight) ? (int)$product->weight.''.getWeightUnit($product->weight_unit): ''; ?>">
            <button type="submit" class="btn_new btn-1 hover-filled-slide-right"><span><i class="fa-solid fa-bucket"></i>Add To Cart</span></button>
          <?php echo form_close(); ?>

          </div>
        </div>
      </div>
    <?php } ?>

    </div>
  </div>
</section>

<?php if ($this->session->flashdata('success') != '') { ?>
  <div class="alert alert-primary" id="crdAddMgs" style="text-align: center; margin: 20px 0 0 0;">
    <?php echo $this->session->flashdata('success'); ?>
  </div>
<?php } ?>


<section class="who_we_are common_margin" id="about">
  <div class="container">
    <div class="who_we_are_inner">
      <h2>Who We Are</h2>
      <p>At <strong>ALL SEASONS MAKHANA</strong>, we aim to deliver the finest premium makhana that enriches your health and elevates your snacking experience. By partnering with expert farmers in Bihar and following strict quality standards, we ensure every foxnut is wholesome, delicious, and pure.</p>
      <p>Established in May 2025, we are committed to creating positive impact—pledging 1% of our share from 2026 to support education through NGO initiatives. With us, you choose quality, care, and a brand with purpose.</p>
      <div class="who_we_are_img">
        <img src="assets/images/happy-clients-image.webp" class="img-fluid">
        <h6>10K+ Happy Customer</h6>
      </div>
    </div>
  </div>
</section>

<section class="why-makhana-section" id="why-choose-us">
  <div class="container">
    <h3 class="why-title">Why ALL SEASONS MAKHANA?</h3>

    <ul class="why-list">
      <li>100% Natural & Preservative-Free</li>
      <li>High Nutritional Value</li>
      <li>Crunchy, Fresh & Hygienically Processed</li>
      <li>Light, Healthy & Gluten-Free Snack</li>
      <li>Trusted Quality from Farm to Pack</li>
    </ul>
  </div>
</section>

<section class="power_packed_with  common_padding" id="benefits">
  <div class="container">
    <div class="power_packed_with_inner">
      <h2>Power - Packed with<span>Health Benefits</span></h2>
      <div class="power_packed_with_img text-center">
        <img src="assets/images/power-section-image.webp" class="img-fluid">
      </div>
      <div class="power_packed_with_ul_li">
        <ul>
          <li>Rich in protein & antioxidants</li>
          <li>Supports weight management</li>
          <li>Good for heart health</li>
          <li>Gluten-free & easy to digest</li>
          <li>Perfect for diabetic-friendly diets</li>
        </ul>
      </div>
    </div>
  </div>
</section>

<section class="certifications_quality">
  <div class="container">
    <div class="row align-items-cente">
      <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12">
        <div class="certifications_quality_left">
          <div class="certifications_quality_left_inner">
            <h2>Certifications & Quality<span>Assurance</span></h2>
            <p>At <strong>All Seasons Makhana</strong>, quality, safety, and compliance are at the core of everything we do. Our products are manufactured and marketed in strict accordance with food safety regulations and internationally recognized quality standards.</p>
          </div>
        </div>
      </div>
      <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
        <div class="certifications_quality_right">
          <img src="assets/images/certificate-image.webp" alt="certificate" class="img-fluid">
        </div>
      </div>
    </div>
  </div>
</section>

<section class="get_in_touch_with_us">
  <div class="container">
    <div class="get_in_touch_with_us_inner">
      <div class="row">

        <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12">
          <div class="get_in_touch_with_us_left">
            <img src="assets/images/get-in-touch-section-image.webp" class="img-fluid">
          </div>
        </div>

        <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-12 col-sm-12 col-12">
          <div class="get_in_touch_with_us_right" id="contact">
            <h2>Get in Touch With Us</h2>
            <p>Have questions or bulk inquiries? We’d love to hear from you!</p>
            <?php echo form_open('', ['id' => 'contactForm', 'class' => 'get_in_touch_with_us_right_form', 'method' => 'post']); ?>
            <div class="row">

              <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="mb-3">
                  <label class="form-label">Full Name</label>
                  <input type="text" name="full_name" class="form-control custom_control" placeholder="Enter your full name">
                </div>
              </div>

              <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                <div class="mb-3">
                  <label class="form-label">Email ID</label>
                  <input type="email" name="email" class="form-control custom_control" placeholder="Enter your email id">
                </div>
              </div>

              <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                <div class="mb-3">
                  <label class="form-label">Phone Number</label>
                  <input type="text" name="phone" class="form-control custom_control" placeholder="+91 0000 000 000">
                </div>
              </div>

              <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="mb-3">
                  <label class="form-label">Address</label>
                  <input type="text" name="address" class="form-control custom_control" placeholder="Enter your address">
                </div>
              </div>

              <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="mb-3">
                  <label class="form-label">Message</label>
                  <textarea name="message" class="form-control message_control" placeholder="Enter your message..." rows="4"></textarea>
                </div>
              </div>

              <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="get_in_touch_with_us_right_form_button">
                  <button type="submit" class="btn_new btn-1 hover-filled-slide-right"><span>Send Message</span></button>
                </div>
              </div>

            </div>
            <?php echo form_close(); ?>
            <div id="responseMsg" class="mt-3"></div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>